﻿using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects
{
    /// <summary>
    /// Manages GPS records for cellular topology.
    /// </summary>
    partial class GpsRecordsManager
    {
        /// <summary>
        /// Represents tuple containing location and normalized direction vector.
        /// </summary>
        public struct LocationAndDirection
        {
            /// <summary>
            /// Location.
            /// </summary>
            public Point Location;

            /// <summary>
            /// Normalized direction vector.
            /// </summary>
            public Vector DirectionNormalizedVector;

            /// <summary>
            /// Initializes structure with location and normalized direction vector.
            /// </summary>
            /// <param name="point">Location.</param>
            /// <param name="normalizedDirectionVector">Normalized direction vector.</param>
            internal LocationAndDirection(Point point, Vector directionNormalizedVector)
            {
                Location = point;
                DirectionNormalizedVector = directionNormalizedVector;
            }
        }
    }
}
